<?php $__env->startSection('page-title', 'تعديل المناسبة'); ?>
<?php $__env->startSection('content'); ?>

<!-- Start Create Event Section -->
<h3>تعديل مناسبة</h3>
<div class="col-xl-12 mt-4">
  <?php if(session()->has('eventSuccess')): ?>
  <script>
    Swal.fire({
      icon: 'success',
      title: 'تم بنجاح',
      text: "<?php echo e(session('eventSuccess')); ?>",
      confirmButtonText: 'حسناً'
    });
  </script>
  <?php endif; ?>

  <?php if(session()->has('eventError')): ?>
  <script>
    Swal.fire({
      icon: 'error',
      title: 'خطأ',
      text: "<?php echo e(session('eventError')); ?>",
      confirmButtonText: 'إغلاق'
    });
  </script>
  <?php endif; ?>

  <div class="card height-equal">
    <div class="card-header pb-0">
      <h4>نموذج إدخال مناسبة</h4>
      <p class="f-m-light mt-1">يرجى تعبئة كافة الحقول بشكل صحيح قبل الإرسال.</p>
    </div>
    <div class="card-body">
      <form class="row g-3 needs-validation custom-input" novalidate="" action="<?php echo e(route('dashboard.updateEvent', ['user' => $user->id, 'event' => $event->id])); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="col-12">
          <label class="form-label" for="clientName">اسم المناسبة</label>
          <input class="form-control" id="clientName" type="text" name="event_name" value="<?php echo e(old('event_name', $event->event_name)); ?>" placeholder="مثال: حفل زواج مزن وعبدالعزيز" required>
          <?php $__errorArgs = ['event_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <div class="text-danger">
            <?php echo e($message); ?>

          </div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="col-6">
          <label class="form-label" for="sourceTransfer">تاريخ المناسبة</label>
          <input class="form-control" id="sourceTransfer" type="date" name="event_date" value="<?php echo e(old('event_date', $event->event_date)); ?>" placeholder="مثال: 2026-01-18" min="<?php echo e(date('Y-m-d')); ?>" required>
          <?php $__errorArgs = ['event_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <div class="text-danger">
            <?php echo e($message); ?>

          </div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="col-6">
          <label class="form-label" for="sourceTransfer">زمن المناسبة</label>
          <input class="form-control" id="sourceTransfer" type="time" name="event_time" value="<?php echo e(old('event_time', $event->event_time)); ?>" placeholder="مثال: 2026-01-18" min="<?php echo e(date('H:i')); ?>" required>
          <?php $__errorArgs = ['event_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <div class="text-danger">
            <?php echo e($message); ?>

          </div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="col-md-6">
          <label class="form-label" for="contractNumber">مكان المناسبة</label>
          <input class="form-control" id="contractNumber" type="text" name="event_location" value="<?php echo e(old('event_location', $event->event_location)); ?>" placeholder="مثال: قاعة اللؤلؤة" required>
          <?php $__errorArgs = ['event_location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <div class="text-danger">
            <?php echo e($message); ?>

          </div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="col-md-6">
          <label class="form-label" for="contractNumber">رابط الموقع</label>
          <input class="form-control" id="contractNumber" type="text" name="location_url" value="<?php echo e(old('location_url', $event->location_url)); ?>" placeholder="مثال: https://maps.app.goo.gl/" required>
          <?php $__errorArgs = ['location_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <div class="text-danger">
            <?php echo e($message); ?>

          </div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="col-md-12">
          <label class="form-label" for="signDate">صورة الدعوة</label>
          <input class="form-control" id="signDate" type="file" name="event_image" value="<?php echo e(old('event_image', $event->event_image)); ?>" required>
          <?php $__errorArgs = ['event_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <div class="text-danger">
            <?php echo e($message); ?>

          </div>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>


        <div class="col-12">
          <button class="btn btn-primary" type="submit">إضافة المناسبة</button>
        </div>
      </form>
    </div>
  </div>
</div>
<!-- End   Create Event Section -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.partial.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\inviter\resources\views/theme/dashboard/editEvent.blade.php ENDPATH**/ ?>