<?php $__env->startSection('page-title', 'دعوات مناسبة ' . $event->event_name); ?>
<?php $__env->startSection('content'); ?>

<?php if(session()->has('generateInvitationsSuccess')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'تم بنجاح 🎉',
        text: "<?php echo e(session('generateInvitationsSuccess')); ?>",
        confirmButtonText: 'تمام',
        timer: 3000,
        timerProgressBar: true
    });
</script>
<?php endif; ?>


<!-- My Invitations -->
<div class="col-xl-12 proorder-xl-3 box-col-6 mt-4">
  <div class="card">
    <div class="card-header pb-0">
      <div class="header-top">
        <h1>
          دعواتي - <?php echo e($event->event_name); ?>

        </h1>
        <div class="dropdown icon-dropdown setting-menu">
          <button class="btn dropdown-toggle" id="userdropdown4" type="button" data-bs-toggle="dropdown" aria-expanded="false">
            <svg>
              <use href="<?php echo e(asset('assets/svg/icon-sprite.svg')); ?>#setting"> </use>
            </svg>
          </button>
          <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown4">
            <a class="dropdown-item" href="#">أسبوعي</a>
            <a class="dropdown-item" href="#">شهري</a>
            <a class="dropdown-item" href="#">سنوي</a>
          </div>
        </div>
      </div>
    </div>
    <div class="card-body">
      <div class="table-responsive custom-scrollbar">
        <table class="last-orders-table table" id="last-orders">
          <thead>
            <tr>
              <th>#</th>
              <th>كود الدعوة</th>
              <th>الحالة</th>
              <th>إجراءات</th>
            </tr>
          </thead>
          <tbody>
            <?php if($invitations->isEmpty()): ?>
            <tr>
              <td colspan="5" class="text-center">لا يوجد دعوات</td>
            </tr>
            <?php else: ?>
            <?php $__currentLoopData = $invitations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invitation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($invitations->firstItem() + $loop->iteration - 1); ?></td>
              <td>
                <a href="<?php echo e(route('theme.invitation', $invitation->invitation_url)); ?>">
                  <img src="<?php echo e(asset('storage/' . $invitation->qr_image_path)); ?>" alt="<?php echo e($invitation->qr_token); ?>" width="100" height="100">
                </a>
              </td>
              <td>
                <span class="badge <?php echo e($invitation->is_used ? 'bg-danger' : 'bg-success'); ?>">
                  <?php echo e($invitation->is_used ? 'مستخدمة' : 'غير مستخدمة'); ?>

                </span>
              </td>

              <td>
                <ul class="action gap-3">
                  <li class="primary">
                    <a target="_blank" href="<?php echo e(route('theme.invitation', $invitation->invitation_url)); ?>">
                      <i class="icon-eye"></i>
                    </a>
                  </li>
                  <li class="edit">
                    <a href="#">
                      <i class="icon-share"></i>
                    </a>
                  </li>
                  <!-- <li class="delete"><a href="#"><i class="icon-trash"></i></a></li> -->
                </ul>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          </tbody>
        </table>
        <?php if($invitations->hasPages()): ?>
        <div class="mt-4 me-4">
          <?php echo e($invitations->links('pagination::bootstrap-5')); ?>

        </div>
        <?php endif; ?>

        <a href="<?php echo e(route('theme.event', $event->event_slug)); ?>" target="_blank" rel="noopener noreferrer">
          <button class="btn btn-primary btn-lg text-light mt-4 p-2">
            أضف دعوات جديدة لـ <?php echo e($event->event_name); ?>

          </button>
        </a>
      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.partial.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\inviter\resources\views/theme/invitations.blade.php ENDPATH**/ ?>