<?php

use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ThemeController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\ScanController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AccountsController;


Route::get('/dashboard', function () {
  return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
  Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
  Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
  Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__ . '/auth.php';



/*
*
* Public Routes => { guest }
*/
// Login Route 
Route::get('/login', [AuthenticatedSessionController::class, 'create'])->name('login')->middleware('guest');
// Signup Route 
Route::get('/signup', [AuthenticatedSessionController::class, 'create'])->name('signup')->middleware('guest');
// Invitation Route 
Route::get('/invitation/{slug}', [ThemeController::class, 'invitation'])->name('theme.invitation');
// home route 
Route::get('/', [ThemeController::class, 'home'])->name('theme.home')->middleware('auth', 'verified');


/*
*
* Project Routes 
* Theme Routes => { admin, staff, guest }
*  ThemeController => { admin, staff, guest }
*/



/*
*
* Scanner Route => { staff }
*/
Route::resource('scan', ScanController::class)->middleware(['auth', 'role:staff', 'verified'])->only(['index']);
Route::resource('scan', ScanController::class)->middleware(['auth', 'role:admin', 'verified'])->except(['index']);
Route::post('/scan/verify', [ScanController::class, 'verifyToken'])->name('scan.verify')->middleware(['auth', 'role:staff', 'throttle:5,1']);
Route::get('/organizers', [ScanController::class, 'showTeamMembers'])->name('scan.showTeamMembers')->middleware(['auth', 'role:admin', 'verified']);


/*
*
* Event Owner Routes => { admin }
*  ThemeController => { admin }
*/

Route::middleware(['auth', 'role:admin'])->controller(ThemeController::class)->name('theme.')->group(function () {
  Route::get('/event/{slug}', 'event')->name('event');
  Route::get('/invitations/{slug}', 'invitations')->name('invitations');
  Route::get('/templates', 'templates')->name('templates');
  Route::get('/settings', 'settings')->name('settings');
});


// Events Resource Routes => { admin }
Route::middleware(['auth', 'role:admin'])->resource('events', EventController::class)->names('events');

// Generate Invitations Routes => { admin }
Route::post('/events/{event}/invitations/generate', [EventController::class, 'generateInvitations'])
  ->name('invitations.generate')
  ->middleware(['auth', 'role:admin', 'verified']);



/*
  *
  * Super Admin Dashboard Routes => { Super Admin }
  *  DashboardController => { Super Admin }
  */

Route::middleware(['auth', 'role:super-admin', 'verified'])->controller(DashboardController::class)->name('dashboard.')->group(function () {
  Route::get('/dashboard', 'index')->name('home');
  // show user events
  Route::get('/accounts/{account}/events', 'events')->name('userEvents');
  // show user event edit page
  Route::get('/accounts/{user:id}/event/{event:id}/edit', 'editEvent')->name('editEvent');
  // update user event
  Route::put('/accounts/{user:id}/event/{event:id}/update', 'updateEvent')->name('updateEvent');
  // delete user event
  Route::delete('/accounts/{user:id}/event/{event:id}/delete', 'deleteEvent')->name('deleteEvent');
});


// Accounts Resource Routes => { super-admin }
Route::middleware(['auth', 'role:super-admin', 'verified'])->resource('accounts', AccountsController::class)->names('accounts');
