@extends('theme.partial.master')
@section('page-title', 'Scanner')
@section('content')


<div class="container py-4">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body p-4">
      <h4 class="mb-2">فحص الدعوات بالكاميرا</h4>
      <div class="text-muted mb-3">وجّه الكاميرا نحو QR — سيتم التحقق تلقائيًا.</div>

      <div class="scanner-wrap mb-3" style="position:relative; border-radius:16px; overflow:hidden; background:#000;">
        <video id="video" playsinline style="width:100%; height:340px; object-fit:cover;"></video>

        <!-- Overlay بسيط -->
        <div style="position:absolute; inset:0; pointer-events:none;">
          <div style="position:absolute; inset:0; margin:auto; width:min(76%,360px); aspect-ratio:1/1;
                      border:3px solid rgba(255,255,255,.85); border-radius:16px;
                      box-shadow:0 0 0 9999px rgba(0,0,0,.35);">
            <div style="position:absolute; left:10%; right:10%; height:3px; top:12%;
                        background:rgba(25,135,84,.95); border-radius:999px;
                        filter:drop-shadow(0 0 6px rgba(25,135,84,.6));
                        animation:scanMove 1.4s infinite ease-in-out;"></div>
          </div>
        </div>
      </div>

      <style>
        @keyframes scanMove {
          0% {
            top: 12%;
            opacity: .75;
          }

          50% {
            top: 82%;
            opacity: 1;
          }

          100% {
            top: 12%;
            opacity: .75;
          }
        }

        @media (max-width: 576px) {
          #video {
            height: 420px !important;
          }
        }
      </style>

      <div class="d-flex gap-2 flex-wrap">
        <button id="btnStart" class="btn btn-primary" type="button">تشغيل الكاميرا</button>
        <button id="btnStop" class="btn btn-outline-secondary" type="button" disabled>إيقاف</button>
        <button id="btnSwitch" class="btn btn-outline-primary" type="button" disabled>تبديل الكاميرا</button>
      </div>

      <div class="alert alert-warning mt-3 mb-0">
        ⚠️ بعض المتصفحات تتطلب HTTPS لعمل الكاميرا. على localhost يعمل غالبًا بدون HTTPS.
      </div>
    </div>
  </div>
</div>

{{-- Libraries --}}
<script src="https://cdn.jsdelivr.net/npm/jsqr@1.4.0/dist/jsQR.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
  let stream = null;
  let rafId = null;
  let scanning = false;
  let facingMode = "environment";
  let lock = false;

  const video = document.getElementById('video');
  const btnStart = document.getElementById('btnStart');
  const btnStop = document.getElementById('btnStop');
  const btnSwitch = document.getElementById('btnSwitch');

  const canvas = document.createElement('canvas');
  const ctx = canvas.getContext('2d', {
    willReadFrequently: true
  });

  // ✅ استخراج UUID من أي مكان داخل QR (رابط مثل /invitation/{uuid} أو query أو نص)
  function extractToken(qrData) {
    const data = String(qrData || '').trim();
    const uuidMatch = data.match(/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/);
    return uuidMatch ? uuidMatch[0] : null;
  }

  function stopCamera() {
    scanning = false;
    if (rafId) cancelAnimationFrame(rafId);
    rafId = null;

    if (video) {
      video.pause();
      video.srcObject = null;
    }
    if (stream) {
      stream.getTracks().forEach(t => t.stop());
      stream = null;
    }

    btnStop.disabled = true;
    btnSwitch.disabled = true;
  }

  async function startCamera() {
    try {
      stopCamera();

      stream = await navigator.mediaDevices.getUserMedia({
        video: {
          facingMode: {
            ideal: facingMode
          }
        },
        audio: false
      });

      video.srcObject = stream;
      await video.play();

      scanning = true;
      btnStop.disabled = false;
      btnSwitch.disabled = false;

      scanLoop();
    } catch (err) {
      console.error(err);
      Swal.fire({
        icon: 'error',
        title: 'تعذر فتح الكاميرا',
        text: 'تأكد من السماح بالكاميرا أو استخدم HTTPS'
      });
    }
  }

  async function verifyTokenOnServer(token) {
    const meta = document.querySelector('meta[name="csrf-token"]');
    const csrf = meta ? meta.getAttribute('content') : null;

    if (!csrf) {
      return {
        ok: false,
        http: 419,
        data: {
          status: 'error',
          message: 'CSRF token missing'
        }
      };
    }

    const res = await fetch("{{ url('/scan/verify') }}", {
      method: "POST",
      credentials: "same-origin",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "X-Requested-With": "XMLHttpRequest",
        "X-CSRF-TOKEN": csrf,
      },
      body: JSON.stringify({
        token
      })
    });

    const contentType = res.headers.get("content-type") || "";
    const text = await res.text();

    if (contentType.includes("application/json")) {
      return {
        ok: res.ok,
        http: res.status,
        data: JSON.parse(text)
      };
    }

    return {
      ok: false,
      http: res.status,
      data: {
        status: 'error',
        message: 'Server returned non-JSON',
        debug: text.slice(0, 120)
      }
    };
  }

  async function onDetectedToken(token) {
    if (lock) return;
    lock = true;

    try {
      const {
        data,
        http
      } = await verifyTokenOnServer(token);

      if (data.status === 'success' || data.type === 'valid') {
        Swal.fire({
          icon: 'success',
          title: '✅ تم قبول الدعوة',
          text: data.message ?? 'تم التحقق بنجاح',
          timer: 1400,
          showConfirmButton: false
        });

        if (navigator.vibrate) navigator.vibrate(120);

        // (اختياري) توقف الكاميرا بعد نجاح
        // stopCamera();

      } else if (data.type === 'used') {
        Swal.fire({
          icon: 'warning',
          title: '⚠️ الدعوة مستخدمة',
          html: `
            <div>${data.message ?? 'تم استخدامها مسبقًا'}</div>
            ${data.used_at ? `<div class="text-muted small mt-1">وقت الاستخدام: ${data.used_at}</div>` : ''}
          `
        });

      } else if (http === 403) {
        Swal.fire({
          icon: 'error',
          title: 'غير مصرح',
          text: data.message ?? 'غير مصرح'
        });

      } else {
        Swal.fire({
          icon: 'error',
          title: '❌ غير صالحة',
          text: data.message ?? 'تعذر التحقق'
        });
      }

    } catch (e) {
      console.error(e);
      Swal.fire({
        icon: 'error',
        title: 'خطأ',
        text: 'تعذر الاتصال بالسيرفر'
      });
    } finally {
      setTimeout(() => lock = false, 1200);
    }
  }

  function scanLoop() {
    if (!scanning) return;

    if (video.readyState === video.HAVE_ENOUGH_DATA) {
      canvas.width = video.videoWidth;
      canvas.height = video.videoHeight;

      ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
      const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);

      const qr = jsQR(imageData.data, imageData.width, imageData.height, {
        inversionAttempts: "dontInvert"
      });

      if (qr && qr.data) {
        const token = extractToken(qr.data);
        if (token) onDetectedToken(token);
      }
    }

    rafId = requestAnimationFrame(scanLoop);
  }

  btnStart?.addEventListener('click', startCamera);
  btnStop?.addEventListener('click', stopCamera);
  btnSwitch?.addEventListener('click', async () => {
    facingMode = (facingMode === "environment") ? "user" : "environment";
    await startCamera();
  });

  // تشغيل تلقائي
  startCamera();
</script>


<!-- <div class="container py-4">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body p-4">
      <h4 class="mb-2">فحص الدعوات بالكاميرا</h4>
      <div class="text-muted mb-3">وجّه الكاميرا نحو QR — سيتم التحقق تلقائيًا.</div>

      <div class="scanner-wrap mb-3" style="position:relative; border-radius:16px; overflow:hidden; background:#000;">
        <video id="video" playsinline style="width:100%; height:320px; object-fit:cover;"></video>
      </div>

      <div class="d-flex gap-2 flex-wrap">
        <button id="btnStart" class="btn btn-primary" type="button">تشغيل الكاميرا</button>
        <button id="btnStop" class="btn btn-outline-secondary" type="button" disabled>إيقاف</button>
        <button id="btnSwitch" class="btn btn-outline-primary" type="button" disabled>تبديل الكاميرا</button>
      </div>

      <div class="alert alert-warning mt-3 mb-0">
        ⚠️ بعض المتصفحات تتطلب HTTPS لعمل الكاميرا. على localhost يعمل غالبًا بدون HTTPS.
      </div>
    </div>
  </div>
</div> -->
<!-- <div class="container py-4 ">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body p-4">
      <h4 class="mb-2">فحص الدعوات بالكاميرا</h4>
      <div class="small-muted mb-3">وجّه الكاميرا نحو QR — سيتم التحقق تلقائيًا .</div>

      <div class="scanner-wrap mb-3">
        <video id="video" playsinline></video>
        <div class="scan-box">
          <div class="scan-frame">
            <div class="scan-line"></div>
          </div>
        </div>
      </div>

      <div class="d-flex gap-2 flex-wrap">
        <button id="btnStart" class="btn btn-primary">تشغيل الكاميرا</button>
        <button id="btnStop" class="btn btn-outline-secondary" disabled>إيقاف</button>
        <button id="btnSwitch" class="btn btn-outline-primary" disabled>تبديل الكاميرا</button>
      </div>

      <div class="alert alert-warning mt-3 mb-0">
        ⚠️ بعض المتصفحات تتطلب HTTPS لعمل الكاميرا. على localhost يعمل غالبًا بدون HTTPS.
      </div>
    </div>
  </div>
</div>
{{-- مكتبات --}}
<script src="https://cdn.jsdelivr.net/npm/jsqr@1.4.0/dist/jsQR.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
  let stream = null;
  let rafId = null;
  let scanning = false;
  let facingMode = "environment";
  let lock = false;

  const video = document.getElementById('video');
  const btnStart = document.getElementById('btnStart');
  const btnStop = document.getElementById('btnStop');
  const btnSwitch = document.getElementById('btnSwitch');

  const canvas = document.createElement('canvas');
  const ctx = canvas.getContext('2d', {
    willReadFrequently: true
  });

  function extractToken(qrData) {
    const data = String(qrData || '').trim();

    // يلتقط UUID من أي مكان (path/query/نص)
    const uuidMatch = data.match(/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/);
    if (uuidMatch) return uuidMatch[0];

    // لو هو UUID مباشرة
    if (/^[0-9a-fA-F-]{36}$/.test(data)) return data;

    return null;
  }

  function stopCamera() {
    scanning = false;
    if (rafId) cancelAnimationFrame(rafId);
    rafId = null;

    if (video) {
      video.pause();
      video.srcObject = null;
    }

    if (stream) {
      stream.getTracks().forEach(t => t.stop());
      stream = null;
    }

    btnStop.disabled = true;
    btnSwitch.disabled = true;
  }

  async function startCamera() {
    try {
      stopCamera();

      stream = await navigator.mediaDevices.getUserMedia({
        video: {
          facingMode: {
            ideal: facingMode
          }
        },
        audio: false
      });

      video.srcObject = stream;
      await video.play();

      scanning = true;
      btnStop.disabled = false;
      btnSwitch.disabled = false;

      scanLoop();
    } catch (err) {
      console.error(err);
      Swal.fire({
        icon: 'error',
        title: 'تعذر فتح الكاميرا',
        text: 'تأكد من السماح بالكاميرا أو استخدم HTTPS'
      });
    }
  }

  async function verifyTokenOnServer(token) {
    const res = await fetch("{{ url('/scan/verify') }}", {
      method: "POST",
      credentials: "same-origin",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "X-Requested-With": "XMLHttpRequest",
        "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
      },
      body: JSON.stringify({
        token
      })
    });

    const contentType = res.headers.get("content-type") || "";
    const text = await res.text(); // نقرأ كنص أولاً

    // لو السيرفر رجّع JSON فعلاً
    if (contentType.includes("application/json")) {
      return {
        ok: res.ok,
        http: res.status,
        data: JSON.parse(text)
      };
    }

    // لو رجّع HTML (خطأ 500 مثلاً)
    return {
      ok: false,
      http: res.status,
      data: {
        status: "error",
        message: "خطأ بالسيرفر",
        debug: text.slice(0, 200)
      }
    };
  }


  async function onDetectedToken(token) {
    if (lock) return;
    lock = true;

    try {
      const {
        ok,
        data
      } = await verifyTokenOnServer(token);

      // success
      if (data.status === 'success' || data.type === 'valid') {
        Swal.fire({
          icon: 'success',
          title: '✅ تم قبول الدعوة',
          text: data.message ?? 'تم التحقق بنجاح',
          timer: 1800,
          showConfirmButton: false
        });

        // (اختياري) اهتزاز بسيط بالموبايل
        if (navigator.vibrate) navigator.vibrate(120);

      } else if (data.type === 'used') {
        Swal.fire({
          icon: 'warning',
          title: '⚠️ الدعوة مستخدمة',
          html: `
          <div>${data.message ?? 'تم استخدامها مسبقًا'}</div>
          ${data.used_at ? `<div class="text-muted small mt-1">وقت الاستخدام: ${data.used_at}</div>` : ''}
        `
        });

      } else {
        Swal.fire({
          icon: 'error',
          title: '❌ غير صالحة',
          text: data.message ?? 'تعذر التحقق'
        });
      }

    } catch (e) {
      console.error(e);
      Swal.fire({
        icon: 'error',
        title: 'خطأ',
        text: 'تعذر الاتصال بالسيرفر'
      });
    } finally {
      // فك القفل بعد ثانية ونصف
      setTimeout(() => lock = false, 1500);
    }
  }

  function scanLoop() {
    if (!scanning) return;

    if (video.readyState === video.HAVE_ENOUGH_DATA) {
      canvas.width = video.videoWidth;
      canvas.height = video.videoHeight;

      ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
      const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);

      const qr = jsQR(imageData.data, imageData.width, imageData.height, {
        inversionAttempts: "dontInvert"
      });

      if (qr && qr.data) {
        const token = extractToken(qr.data);
        if (token) onDetectedToken(token);
      }
    }

    rafId = requestAnimationFrame(scanLoop);
  }

  btnStart?.addEventListener('click', startCamera);
  btnStop?.addEventListener('click', stopCamera);
  btnSwitch?.addEventListener('click', async () => {
    facingMode = (facingMode === "environment") ? "user" : "environment";
    await startCamera();
  });

  // تشغيل تلقائي
  startCamera();
</script> -->

<!-- 
<div class="container py-4 ">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body p-4">
      <h4 class="mb-2">فحص الدعوات بالكاميرا</h4>
      <div class="small-muted mb-3">وجّه الكاميرا نحو QR — سيتم التحقق تلقائيًا .</div>

      <div class="scanner-wrap mb-3">
        <video id="video" playsinline></video>
        <div class="scan-box">
          <div class="scan-frame">
            <div class="scan-line"></div>
          </div>
        </div>
      </div>

      <div class="d-flex gap-2 flex-wrap">
        <button id="btnStart" class="btn btn-primary">تشغيل الكاميرا</button>
        <button id="btnStop" class="btn btn-outline-secondary" disabled>إيقاف</button>
        <button id="btnSwitch" class="btn btn-outline-primary" disabled>تبديل الكاميرا</button>
      </div>

      <div class="alert alert-warning mt-3 mb-0">
        ⚠️ بعض المتصفحات تتطلب HTTPS لعمل الكاميرا. على localhost يعمل غالبًا بدون HTTPS.
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jsqr@1.4.0/dist/jsQR.js"></script>
<script>
  let stream = null;
  let rafId = null;
  let scanning = false;
  let facingMode = "environment"; // خلفية افتراضيًا
  let lock = false; // يمنع التكرار السريع

  const video = document.getElementById('video');
  const btnStart = document.getElementById('btnStart');
  const btnStop = document.getElementById('btnStop');
  const btnSwitch = document.getElementById('btnSwitch');

  const canvas = document.createElement('canvas');
  const ctx = canvas.getContext('2d', {
    willReadFrequently: true
  });

  function stopCamera() {
    scanning = false;
    if (rafId) cancelAnimationFrame(rafId);
    rafId = null;

    if (video) {
      video.pause();
      video.srcObject = null;
    }

    if (stream) {
      stream.getTracks().forEach(t => t.stop());
      stream = null;
    }

    btnStop.disabled = true;
    btnSwitch.disabled = true;
  }

  async function startCamera() {
    try {
      stopCamera();

      stream = await navigator.mediaDevices.getUserMedia({
        video: {
          facingMode: {
            ideal: facingMode
          }
        },
        audio: false
      });

      video.srcObject = stream;
      await video.play();

      scanning = true;
      btnStop.disabled = false;
      btnSwitch.disabled = false;

      scanLoop();

    } catch (err) {
      console.error(err);
      alert('تعذر فتح الكاميرا. تأكد من الصلاحيات أو استخدم HTTPS.');
    }
  }

  // function extractToken(qrData) {
  //   const data = String(qrData || '').trim();

  //   // لو QR يحتوي رابط فيه ?token= أو ?t=
  //   let m = data.match(/(token|t|code|c|code|c|)=([0-9a-fA-F-]{36})/);
  //   if (m) return m[2];

  //   // لو QR نفسه UUID
  //   if (/^[0-9a-fA-F-]{36}$/.test(data)) return data;

  //   return "not valid";
  // }

  function extractToken(qrData) {
    const data = String(qrData || '').trim();

    // 1️⃣ ابحث عن UUID في أي مكان داخل النص (الرابط أو غيره)
    const uuidMatch = data.match(/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/);

    if (uuidMatch) {
      return uuidMatch[0];
    }

    // 2️⃣ لو النص نفسه UUID فقط
    if (/^[0-9a-fA-F-]{36}$/.test(data)) {
      return data;
    }

    return "not valid";
  }


  async function onDetectedToken(token) {
    if (lock) return;
    lock = true;

    console.log("Detected token:", token);

    // 🔥 هنا ترسل التوكن إلى API للتحقق (اختياري)
    // await verifyToken(token);

    // مثال: اعرضه ثم فك القفل بعد ثانيتين
    alert("QR Token: " + token);
    setTimeout(() => lock = false, 2000);
  }

  function scanLoop() {
    if (!scanning) return;

    if (video.readyState === video.HAVE_ENOUGH_DATA) {
      canvas.width = video.videoWidth;
      canvas.height = video.videoHeight;

      ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
      const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);

      const qr = jsQR(imageData.data, imageData.width, imageData.height, {
        inversionAttempts: "dontInvert"
      });

      if (qr && qr.data) {
        const token = extractToken(qr.data);
        if (token) onDetectedToken(token);
      }
    }

    rafId = requestAnimationFrame(scanLoop);
  }

  btnStart?.addEventListener('click', startCamera);
  btnStop?.addEventListener('click', stopCamera);
  btnSwitch?.addEventListener('click', async () => {
    facingMode = (facingMode === "environment") ? "user" : "environment";
    await startCamera();
  });

  // تشغيل تلقائي عند فتح الصفحة
  startCamera();
</script> -->


@endsection