@extends('theme.partial.master')
@section('page-title', 'إضافة عضو جديد')
@section('content')

<h3>اضافة عضو جديد</h3>
<div class="col-xl-12 mt-4">
  @if(session()->has('addMemberToTeamSuccess'))
  <script>
    Swal.fire({
      icon: 'success',
      title: 'تم بنجاح',
      text: "{{ session('addMemberToTeamSuccess') }}",
      confirmButtonText: 'حسناً'
    });
  </script>
  @endif

  @if(session()->has('addMemberToTeamError'))
  <script>
    Swal.fire({
      icon: 'error',
      title: 'خطأ',
      text: "{{ session('addMemberToTeamError') }}",
      confirmButtonText: 'إغلاق'
    });
  </script>
  @endif

  @if(session()->has('addMemberToTeamAlert'))
  <script>
    Swal.fire({
      icon: 'warning',
      title: 'تنبيه',
      text: "{{ session('addMemberToTeamAlert') }}",
      confirmButtonText: 'حسناً'
    });
  </script>
  @endif


  <div class="card height-equal">
    <div class="card-header pb-0">
      <h4>إضافة أعضاء فريق التنظيم</h4>
      <p class="f-m-light mt-1">يرجى تعبئة كافة الحقول بشكل صحيح قبل الإرسال.</p>
    </div>
    <div class="card-body">
      <form class="row g-3 needs-validation custom-input" novalidate="" action="{{ route('scan.store') }}" method="POST">
        @csrf
        <div class="col-12">
          <label class="form-label" for="clientName">اسم المنظم</label>
          <input class="form-control" id="clientName" type="text" name="event_name" value="{{ old('event_name') }}" placeholder="مثال: حفل زواج مزن وعبدالعزيز" required>
          @error('event_name')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-6">
          <label class="form-label" for="sourceTransfer">البريد الالكتروني</label>
          <input class="form-control" id="sourceTransfer" type="email" name="email" value="{{ old('email') }}" placeholder="مثال: example@gmail.com" autocomplete="off" required>
          @error('email')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-6">
          <label class="form-label" for="sourceTransfer">الباسورد</label>
          <input class="form-control" id="sourceTransfer" type="password" name="password" value="{{ old('password') }}" placeholder="**********" autocomplete="off" required>
          @error('password')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-12">
          <button class="btn btn-primary" type="submit">إضافة العضو</button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection