@extends('theme.partial.master')
@section('page-title', 'تسجيل الدخول')
@section('content')

<div class="container-fluid">
  <div class="row">
    <div class="col-xl-7 p-0" style="background-color: rgba(255, 255, 255, 0.95);">
      <div class="login-card login-dark login-bg">
        <div>
          <div>
            <a class="logo text-center mb-5" href="{{ route('theme.home') }}">
              <img class="img-fluid for-light" src="{{ asset('assets/images/logo/logo-main.png') }}" alt="looginpage" width="300">
              <img class="img-fluid for-dark" src="{{ asset('assets/images/logo/logo-main.png') }}" alt="looginpage" width="300">
            </a>
          </div>
          <div class="login-main">
            <form class="theme-form" method="POST" action="{{ route('login') }}">
              @csrf
              <h4>مرحباً بعودتك 👋</h4>
              <p class="mt-3">أدخل بريدك الإلكتروني وكلمة المرور لتسجيل الدخول</p>
              <div class="form-group">
                <label class="col-form-label">البريد الإلكتروني</label>
                <input class="form-control" type="email" name="email" required placeholder="Test@gmail.com" value="{{ old('email') }}">
                @error('email')
                <span class="text-danger">{{ $message }}</span>
                @enderror
              </div>
              <div class="form-group">
                <label class="col-form-label">كلمة المرور</label>
                <div class="form-input position-relative">
                  <input class="form-control" type="password" name="password" required placeholder="*********">
                  <div class="show-hide">
                    <span class="show"></span>
                  </div>
                </div>
                @error('password')
                <span class="text-danger">{{ $message }}</span>
                @enderror
              </div>
              <div class="form-group mb-0">
                <div class="checkbox p-0">
                  <input id="remember_me" type="checkbox" name="remember">
                  <label class="text-muted" for="remember_me">تذكرني</label>
                </div>
                <button class="btn btn-primary btn-block w-100" name="login" type="submit">تسجيل الدخول</button>
              </div>
              <p class="mt-4 mb-0 text-center">لا تملك حساب؟<a class="ms-2" href="{{ route('register') }}">إنشاء حساب</a></p>
            </form>
          </div>
          <div class="login-footer text-center mt-4 text-muted">
            <p>© {{ date("Y") }} جميع الحقوق محفوظة</p>
          </div>
          <?php


          ?>
        </div>
      </div>
    </div>
    <div class="col-xl-5 p-0 text-center d-flex justify-content-center align-items-center d-none d-xl-flex" style="background: linear-gradient(135deg, rgba(26, 35, 126, 0.9), rgba(38, 166, 154, 0.9)); flex-direction: column;">
      <img src="assets/images/logo/logo-white.png" alt="شعار" width="200" class="img-fluid mb-3">
      <h2 class="text-white">منصة شاملة لإدارة وتتبع دعواتك</h2>
    </div>
  </div>
</div>

@endsection