@extends('theme.partial.master')
@section('page-title', 'دعوات مناسبة ' . $event->event_name)
@section('content')

@if(session()->has('generateInvitationsSuccess'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'تم بنجاح 🎉',
        text: "{{ session('generateInvitationsSuccess') }}",
        confirmButtonText: 'تمام',
        timer: 3000,
        timerProgressBar: true
    });
</script>
@endif


<!-- My Invitations -->
<div class="col-xl-12 proorder-xl-3 box-col-6 mt-4">
  <div class="card">
    <div class="card-header pb-0">
      <div class="header-top">
        <h1>
          دعواتي - {{ $event->event_name }}
        </h1>
        <div class="dropdown icon-dropdown setting-menu">
          <button class="btn dropdown-toggle" id="userdropdown4" type="button" data-bs-toggle="dropdown" aria-expanded="false">
            <svg>
              <use href="{{ asset('assets/svg/icon-sprite.svg') }}#setting"> </use>
            </svg>
          </button>
          <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown4">
            <a class="dropdown-item" href="#">أسبوعي</a>
            <a class="dropdown-item" href="#">شهري</a>
            <a class="dropdown-item" href="#">سنوي</a>
          </div>
        </div>
      </div>
    </div>
    <div class="card-body">
      <div class="table-responsive custom-scrollbar">
        <table class="last-orders-table table" id="last-orders">
          <thead>
            <tr>
              <th>#</th>
              <th>كود الدعوة</th>
              <th>الحالة</th>
              <th>إجراءات</th>
            </tr>
          </thead>
          <tbody>
            @if ($invitations->isEmpty())
            <tr>
              <td colspan="5" class="text-center">لا يوجد دعوات</td>
            </tr>
            @else
            @foreach ($invitations as $invitation)
            <tr>
              <td>{{ $invitations->firstItem() + $loop->iteration - 1 }}</td>
              <td>
                <a href="{{ route('theme.invitation', $invitation->invitation_url) }}">
                  <img src="{{ asset('storage/' . $invitation->qr_image_path) }}" alt="{{ $invitation->qr_token }}" width="100" height="100">
                </a>
              </td>
              <td>
                <span class="badge {{ $invitation->is_used ? 'bg-danger' : 'bg-success' }}">
                  {{ $invitation->is_used ? 'مستخدمة' : 'غير مستخدمة' }}
                </span>
              </td>

              <td>
                <ul class="action gap-3">
                  <li class="primary">
                    <a target="_blank" href="{{ route('theme.invitation', $invitation->invitation_url) }}">
                      <i class="icon-eye"></i>
                    </a>
                  </li>
                  <li class="edit">
                    <a href="#">
                      <i class="icon-share"></i>
                    </a>
                  </li>
                  <!-- <li class="delete"><a href="#"><i class="icon-trash"></i></a></li> -->
                </ul>
              </td>
            </tr>
            @endforeach
            @endif
          </tbody>
        </table>
        @if ($invitations->hasPages())
        <div class="mt-4 me-4">
          {{ $invitations->links('pagination::bootstrap-5') }}
        </div>
        @endif

        <a href="{{ route('theme.event', $event->event_slug) }}" target="_blank" rel="noopener noreferrer">
          <button class="btn btn-primary btn-lg text-light mt-4 p-2">
            أضف دعوات جديدة لـ {{ $event->event_name }}
          </button>
        </a>
      </div>
    </div>
  </div>
</div>

@endsection