@extends('theme.partial.master')
@section('page-title', $event->event_name)
@section('content')

<!-- Start Event Section -->
<div class="col-xl-12 proorder-xl-3 box-col-12 mt-4">
  <div class="card">
    <div class="card-header pb-0">
      <div class="header-top">
        <h1>مناسباتي</h1>
        <div class="dropdown icon-dropdown setting-menu">
          <button class="btn dropdown-toggle" id="userdropdown4" type="button" data-bs-toggle="dropdown" aria-expanded="false">
            <svg>
              <use href="{{ asset('assets/svg/icon-sprite.svg') }}#setting"> </use>
            </svg>
          </button>
          <!-- <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown4">
            <a class="dropdown-item" href="#">أسبوعي</a>
            <a class="dropdown-item" href="#">شهري</a>
            <a class="dropdown-item" href="#">سنوي</a>
          </div> -->
        </div>
      </div>
    </div>
    <!-- Start Event Body -->
    <div class="card-body p-4 p-lg-5">

      <div class="row g-4 align-items-stretch">

        <!-- Image Column -->
        <div class="col-lg-5">
          <div class="event-cover ratio ratio-4x3 rounded-4 overflow-hidden shadow-sm bg-light">
            <img
              src="{{ asset('storage/' . $event->event_image) }}"
              alt="event-image"
              class="w-100 h-100 object-fit-cover">
          </div>

          <!-- Mini Info (optional) -->
          <!-- <div class="d-flex flex-wrap gap-2 mt-3">
            <span class="badge text-bg-success rounded-pill px-3 py-2">
              <span class="me-1">●</span> مؤكد
            </span>

            <span class="badge text-bg-light border rounded-pill px-3 py-2 text-muted">
              #{{ $event->id ?? '' }}
            </span>
          </div> -->
        </div>

        <!-- Details Column -->
        <div class="col-lg-7">
          <div class="d-flex flex-column h-100">

            <!-- Title + Badge -->
            <div class="d-flex justify-content-between align-items-start gap-3 mb-3">
              <div>
                <h3 class="fw-bold mb-1">{{ $event->event_name }}</h3>
                <!-- <div class="text-muted small">
                  تفاصيل المناسبة
                </div> -->
              </div>
            </div>
            <!-- Info Cards -->
            <div class="row g-3">

              <!-- Date -->
              <div class="col-md-6">
                <div class="p-3 border rounded-4 h-100 bg-white shadow-sm">
                  <div class="d-flex align-items-center gap-3">
                    <div class="icon-circle">
                      <i class="fa fa-calendar"></i>
                    </div>
                    <div>
                      <div class="fw-semibold">التاريخ</div>
                      <div class="text-muted">{{ $event->event_date }}</div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Time -->
              <div class="col-md-6">
                <div class="p-3 border rounded-4 h-100 bg-white shadow-sm">
                  <div class="d-flex align-items-center gap-3">
                    <div class="icon-circle">
                      <i class="fa-regular fa-clock"></i>
                    </div>
                    <div>
                      <div class="fw-semibold">الوقت</div>
                      <div class="text-muted">{{ $event->event_time }}</div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Location -->
              <div class="col-12">
                <div class="p-3 border rounded-4 bg-white shadow-sm">
                  <div class="d-flex align-items-center gap-3">
                    <div class="icon-circle">
                      <i class="fa-solid fa-location-dot"></i>
                    </div>
                    <div class="flex-grow-1">
                      <div class="fw-semibold">المكان</div>
                      <div class="text-muted">{{ $event->event_location }}</div>
                    </div>

                    <!-- Optional action button -->
                    <a href="{{ $event->location_url }}"
                      target="_blank"
                      class="btn btn-outline-primary btn-sm rounded-pill px-3">
                      فتح بالخريطة
                    </a>
                  </div>
                </div>
              </div>

              <!-- Generate Invitations Form -->

              <!-- Errors Message -->
              @if(session()->has('generateInvitationsError'))
              <script>
                Swal.fire({
                  icon: 'warning',
                  title: 'تنبيه',
                  text: "{{ session('generateInvitationsError') }}",
                  confirmButtonText: 'موافق'
                });
              </script>
              @endif


              <!-- Title + Badge -->
              <div class="d-flex justify-content-between align-items-start gap-3 mb-1 mt-5">
                <div>
                  <h3 class="fw-bold mb-1">توليد الدعوات</h3>
                  <!-- <div class="text-muted small">
                  تفاصيل المناسبة
                </div> -->
                </div>
              </div>

              <form action="{{ route('invitations.generate', $event->id) }}" method="post">
                @csrf
                <input type="hidden" name="event_id" value="{{ $event->id }}">

                <div class="col-md-12 mt-3">
                  <label class="form-label" for="contractNumber">عدد الدعوات</label>
                  <input class="form-control" id="contractNumber" type="number" name="invitation_count" value="{{ old('invitation_count') }}" placeholder="{{ 'الحد الأقصى ' . $user->user_invitation_limit . ' دعوة' . ' المتبقي ' . ($user->user_invitation_limit - $event->invitations->count()) }}" min="1" max="{{ $user->user_invitation_limit }}" required>
                  @error('invitation_count')
                  <div class="text-danger">
                    {{ $message }}
                  </div>
                  @enderror
                </div>
                @if ($user->user_invitation_limit < 10)
                  <span class="text-danger mt-2">*تواصل معنا لشراء دعوات</span>
                  @endif
                  <div class="col-md-12 mt-3">
                    <button class="btn btn-primary" type="submit">إنشاء دعوات</button>
                  </div>
              </form>

            </div>


          </div>
        </div>

      </div>
    </div>
    <!-- End Event Body -->

    <style>
      .object-fit-cover {
        object-fit: cover;
      }

      .icon-circle {
        width: 44px;
        height: 44px;
        border-radius: 999px;
        display: grid;
        place-items: center;
        background: rgba(13, 110, 253, .08);
        /* primary tint */
        border: 1px solid rgba(13, 110, 253, .15);
      }

      .icon-svg {
        width: 20px;
        height: 20px;
        opacity: .9;
      }
    </style>
  </div>
</div>
<!-- End Event Section -->

@endsection