@extends('theme.partial.master')
@section('page-title', 'تعديل المناسبة')
@section('content')

<!-- Start Create Event Section -->
<h3>تعديل مناسبة</h3>
<div class="col-xl-12 mt-4">
  @if(session()->has('eventSuccess'))
  <script>
    Swal.fire({
      icon: 'success',
      title: 'تم بنجاح',
      text: "{{ session('eventSuccess') }}",
      confirmButtonText: 'حسناً'
    });
  </script>
  @endif

  @if(session()->has('eventError'))
  <script>
    Swal.fire({
      icon: 'error',
      title: 'خطأ',
      text: "{{ session('eventError') }}",
      confirmButtonText: 'إغلاق'
    });
  </script>
  @endif

  <div class="card height-equal">
    <div class="card-header pb-0">
      <h4>نموذج إدخال مناسبة</h4>
      <p class="f-m-light mt-1">يرجى تعبئة كافة الحقول بشكل صحيح قبل الإرسال.</p>
    </div>
    <div class="card-body">
      <form class="row g-3 needs-validation custom-input" novalidate="" action="{{ route('dashboard.updateEvent', ['user' => $user->id, 'event' => $event->id]) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="col-12">
          <label class="form-label" for="clientName">اسم المناسبة</label>
          <input class="form-control" id="clientName" type="text" name="event_name" value="{{ old('event_name', $event->event_name) }}" placeholder="مثال: حفل زواج مزن وعبدالعزيز" required>
          @error('event_name')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-6">
          <label class="form-label" for="sourceTransfer">تاريخ المناسبة</label>
          <input class="form-control" id="sourceTransfer" type="date" name="event_date" value="{{ old('event_date', $event->event_date) }}" placeholder="مثال: 2026-01-18" min="{{ date('Y-m-d') }}" required>
          @error('event_date')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-6">
          <label class="form-label" for="sourceTransfer">زمن المناسبة</label>
          <input class="form-control" id="sourceTransfer" type="time" name="event_time" value="{{ old('event_time', $event->event_time) }}" placeholder="مثال: 2026-01-18" min="{{ date('H:i') }}" required>
          @error('event_time')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-md-6">
          <label class="form-label" for="contractNumber">مكان المناسبة</label>
          <input class="form-control" id="contractNumber" type="text" name="event_location" value="{{ old('event_location', $event->event_location) }}" placeholder="مثال: قاعة اللؤلؤة" required>
          @error('event_location')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-md-6">
          <label class="form-label" for="contractNumber">رابط الموقع</label>
          <input class="form-control" id="contractNumber" type="text" name="location_url" value="{{ old('location_url', $event->location_url) }}" placeholder="مثال: https://maps.app.goo.gl/" required>
          @error('location_url')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>

        <div class="col-md-12">
          <label class="form-label" for="signDate">صورة الدعوة</label>
          <input class="form-control" id="signDate" type="file" name="event_image" value="{{ old('event_image', $event->event_image) }}" required>
          @error('event_image')
          <div class="text-danger">
            {{ $message }}
          </div>
          @enderror
        </div>


        <div class="col-12">
          <button class="btn btn-primary" type="submit">إضافة المناسبة</button>
        </div>
      </form>
    </div>
  </div>
</div>
<!-- End   Create Event Section -->

@endsection