<!-- Start Summary Section -->
<div class="col-xl-12 proorders-xl-2">
  <div class="card">
    <div class="card-header pb-0">
      <div class="header-top">
        <h4>{{ $title ?? 'الملخص' }}</h4>

        {{-- إذا لا تريد القائمة المنسدلة احذف هذا البلوك أو اجعله اختياري --}}
        <div class="dropdown icon-dropdown setting-menu">
          <button class="btn dropdown-toggle" type="button" data-bs-toggle="dropdown">
            <svg>
              <use href="{{ asset('assets/svg/icon-sprite.svg') }}#setting"></use>
            </svg>
          </button>
          <div class="dropdown-menu dropdown-menu-end">
            <a class="dropdown-item" href="#">اسبوعي</a>
            <a class="dropdown-item" href="#">شهري</a>
            <a class="dropdown-item" href="#">سنوي</a>
          </div>
        </div>

      </div>
    </div>

    <div class="card-body pt-0 summary-card">
      <span class="f-w-700 f-14">
        منذ البداية إلى {{ date('Y-m-d') }}
      </span>

      <div class="summary-progressbar">
        <ul>
          @forelse ($stats as $item)
          @php
          // قيم افتراضية
          $label = $item['label'] ?? '';
          $value = $item['value'] ?? 0;

          // اختياري: نسبة شريط التقدم (0 - 100)
          $progress = isset($item['progress']) ? (int) $item['progress'] : 100;
          $progress = max(0, min(100, $progress));

          // اختياري: كلاسات bootstrap
          $borderClass = $item['border'] ?? 'progress-border-primary';
          $barClass = $item['bar'] ?? 'bg-primary';
          @endphp

          <li>
            <div>
              <h4>{{ $value }}</h4>
              <span>{{ $label }}</span>
            </div>

            <div class="progress-showcase">
              <div class="progress sm-progress-bar {{ $borderClass }}">
                <div
                  class="progress-bar {{ $barClass }}"
                  role="progressbar"
                  style="width: {{ $progress }}%"
                  aria-valuenow="{{ $progress }}"
                  aria-valuemin="0"
                  aria-valuemax="100">
                </div>
              </div>
            </div>
          </li>
          @empty
          <li>
            <div>
              <h4>0</h4>
              <span>لا توجد بيانات</span>
            </div>
            <div class="progress-showcase">
              <div class="progress sm-progress-bar progress-border-primary">
                <div class="progress-bar bg-primary" style="width:100%"></div>
              </div>
            </div>
          </li>
          @endforelse
        </ul>
      </div>
    </div>
  </div>
</div>
<!-- End Summary Section -->