document.addEventListener("DOMContentLoaded", function () {
    const editorElement = document.querySelector("textarea#editor1");

    if (!editorElement) return;

    const baseUrl = document.body.getAttribute("data-base-url") || "";

    const scripts = [
        "assets/js/editor/ckeditor/ckeditor.js",
        "assets/js/editor/ckeditor/adapters/jquery.js",
        "assets/js/editor/ckeditor/styles.js",
        "assets/js/editor/ckeditor/ckeditor.custom.js"
    ];

    function loadScriptSequentially(index) {
        if (index >= scripts.length) {            
            
            if (typeof CKEDITOR !== "undefined") {
                if (!CKEDITOR.instances["editor1"]) {
                    CKEDITOR.replace("editor1");
                    console.log("📝 CKEditor تم تفعيله");
                }
            } else {
                console.error("❌ CKEDITOR غير معرف بعد تحميل السكربتات");
            }

            return;
        }

        const script = document.createElement("script");
        script.src = baseUrl + scripts[index];
        script.onload = () => {
            loadScriptSequentially(index + 1);
        };
        script.onerror = () => {
            console.error("❌ فشل تحميل:", scripts[index]);
        };
        document.head.appendChild(script);
    }

    loadScriptSequentially(0);
});
