<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
    public function up(): void
    {
      Schema::create('staff_assignments', function (Blueprint $table) {

        $table->id();
        $table->unsignedBigInteger('owner_id');
        $table->unsignedBigInteger('staff_id');
        $table->timestamps();

        $table->foreign('owner_id')->references('id')->on('users')->onDelete('cascade');
        $table->foreign('staff_id')->references('id')->on('users')->onDelete('cascade');

        $table->unique(['owner_id', 'staff_id']);
      });
    }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('staff_assignments');
  }
};
