<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::table('invitations', function (Blueprint $table) {
      $table->bigInteger('event_id')->unsigned()->nullable();
      $table->foreign('event_id')->references('id')->on('events')->onDelete('cascade');
      $table->string('qr_token')->unique();
      $table->string('invitation_url')->unique();
      $table->string('qr_image_path');
      $table->boolean('is_used')->default(false);
      $table->bigInteger('scanned_by')->unsigned()->nullable();
      $table->foreign('scanned_by')->references('id')->on('users')->onDelete('cascade');
      $table->timestamp('used_at')->nullable();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::table('invitations', function (Blueprint $table) {
      //
    });
  }
};
