<?php

namespace App\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Auth\Events\Verified;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Support\ServiceProvider;
use App\Notifications\AccountActivatedNotification;


class AppServiceProvider extends ServiceProvider
{
  public function boot(): void
  {
    Event::listen(PasswordReset::class, function (PasswordReset $event) {
      $user = $event->user;

      if ($user instanceof MustVerifyEmail && !$user->hasVerifiedEmail()) {
        $user->sendEmailVerificationNotification();
      }
    });
    Event::listen(Verified::class, function (Verified $event) {
      $user = $event->user;
      $user->notify(new AccountActivatedNotification());
    });
  }
}
