<?php

namespace App\Notifications;

use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;

class VerifyEmailCustom extends VerifyEmail
{
  protected function buildMailMessage($url): MailMessage
  {
    return (new MailMessage)
      ->subject('تأكيد البريد الإلكتروني')
      ->greeting('مرحبًا بك 👋')
      ->line('يرجى تأكيد بريدك الإلكتروني لتفعيل حسابك.')
      ->action('تأكيد البريد الإلكتروني', $url)
      ->line('إذا لم تقم بإنشاء هذا الحساب، يمكنك تجاهل الرسالة.');
  }
}
