<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class SetPasswordNotification extends Notification
{
  public function __construct(public string $token) {}

  public function via($notifiable): array
  {
    return ['mail'];
  }

  public function toMail($notifiable): MailMessage
  {
    $url = url(route('password.reset', [
      'token' => $this->token,
      'email' => $notifiable->email,
    ], false));

    return (new MailMessage)
      ->subject('تعيين كلمة المرور')
      ->greeting('مرحبًا ' . $notifiable->name . ' 👋')
      ->line('تم إنشاء حساب لك في منصة Inviteer.')
      ->line('لتعيين كلمة المرور، اضغط على الزر أدناه:')
      ->action('تعيين كلمة المرور', $url)
      ->line('في حال واجهت مشكلة في الضغط على الزر، انسخ الرابط أدناه والصقه في متصفحك.')
      ->line($url)
      ->line('إذا لم تطلب هذا الإجراء، يمكنك تجاهل هذه الرسالة.');
  }
}
