<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Invitation extends Model
{
  protected $fillable = [
    'event_id',
    'qr_token',
    'invitation_url',
    'qr_image_path',
    'is_used',
    'user_id',
    'scanned_by',
    'used_at',
  ];

  protected $casts = [
    'is_used' => 'boolean',
    'used_at' => 'datetime',
  ];



  protected static function booted()
  {
    static::deleting(function ($invitation) {

      // حذف QR
      if (!empty($invitation->qr_image_path) && Storage::disk('public')->exists($invitation->qr_image_path)) {
        Storage::disk('public')->delete($invitation->qr_image_path);
      }

      // حذف صورة الدعوة (إن وجدت عندك)
      if (!empty($invitation->image_path) && Storage::disk('public')->exists($invitation->image_path)) {
        Storage::disk('public')->delete($invitation->image_path);
      }
    });
  }
  public function scanner()
  {
    return $this->belongsTo(User::class, 'scanned_by');
  }

  public function user()
  {
    return $this->belongsTo(User::class, 'user_id');
  }

  public function event()
  {
    return $this->belongsTo(Event::class, 'event_id');
  }
}
