<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class addUserRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   */
  public function authorize(): bool
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
   */
  public function rules(): array
  {
    return [
      'name' => 'required|string|max:255',
      'email' => 'required|email|max:255|unique:users,email',
      'phone_number' => 'required|string|max:12|min:11|regex:/^01[0-9]{9}$/',
      'staff_limit' => 'required|numeric',
      'events_limit' => 'required|numeric',
      'user_invitation_limit' => 'required|numeric',
    ];
  }

  public function messages()
  {
    return [
      'name.required' => 'الاسم مطلوب',
      'email.required' => 'البريد الالكتروني مطلوب',
      'phone_number.required' => 'رقم الهاتف مطلوب',
      'staff_limit.required' => 'الموظفين المتاحين مطلوب',
      'events_limit.required' => 'المناسبات المتاحة مطلوبة',
      'user_invitation_limit.required' => 'الدعوات المتاحة مطلوبة',

      'name.max' => 'الاسم يجب أن يحتوي على 255 حرفًا أو أقل',
      'email.max' => 'البريد الالكتروني يجب أن يحتوي على 255 حرفًا أو أقل',
      'phone_number.max' => 'رقم الهاتف يجب أن يحتوي على 12 رقمًا أو أقل',
      'phone_number.min' => 'رقم الهاتف يجب أن يحتوي على 11 رقمًا أو أكثر',
      'staff_limit.numeric' => 'الموظفين المتاحين يجب أن يكون رقمًا',
      'events_limit.numeric' => 'المناسبات المتاحة يجب أن يكون رقمًا',
      'user_invitation_limit.numeric' => 'الدعوات المتاحة يجب أن يكون رقمًا',

      'email.unique' => 'البريد الالكتروني مستخدم مسبقاً',
    ];
  }
}
