<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class addScanMember extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   */
  public function authorize(): bool
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
   */
  public function rules(): array
  {
    return [
      'event_name' => 'required|string|max:255',
      'email' => 'required|email|max:255|unique:users,email',
      'password' => 'required|string|max:255|min:8',
    ];
  }

  public function messages(): array
  {
    return [
      'event_name.required' => 'اسم المنظم مطلوب',
      'email.required' => 'البريد الالكتروني مطلوب',
      'password.required' => 'الباسورد مطلوب',
      'email.unique' => 'البريد الالكتروني موجود بالفعل',
      'email.email' => 'البريد الالكتروني غير صحيح',
      'password.min' => 'الباسورد يجب ان يحتوي على 8 احرف',
      'event_name.max' => 'اسم المنظم يجب ان يحتوي على 255 حرف',
      'email.max' => 'البريد الالكتروني يجب ان يحتوي على 255 حرف',
      'password.max' => 'الباسورد يجب ان يحتوي على 255 حرف',
    ];
  }
}
