<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Event;
use App\Models\Invitation;
use App\Models\User;

class ThemeController extends Controller
{

  public function home()
  {

    if (Auth::user()->role === 'super-admin') {
      return redirect()->route('dashboard.home');
    }
    $events = Auth::user()
      ->events()
      ->withCount('invitations')
      ->get();

    // $invitations = Auth::user()->invitations;
    return view('theme.home', compact('events'));
  }
  public function events()
  {
    return view('theme.events');
  }
  public function event($slug)
  {
    $event = Auth::user()->events()->where('event_slug', $slug)->firstOrFail();
    $invitations = Invitation::where('user_id', Auth::id())
      ->orderBy('created_at', 'desc')
      ->paginate(10);
    $user = User::findOrFail(Auth::user()->id);
    return view('theme.event', compact('event', 'invitations', 'user'));
  }


  public function invitations(Event $event, $slug)
  {

    $event = Auth::user()->events()->where('event_slug', $slug)->firstOrFail();

    $invitations = $event->invitations()->paginate(10);

    return view('theme.invitations', compact('invitations', 'event'));
  }

  // public function invitations()
  // {
  //   // $invitations = Auth::user()->invitations->orderBy('created_at', 'desc')->paginate(10);

  //   $invitations = Invitation::where('user_id', Auth::id())
  //     ->orderBy('created_at', 'desc')
  //     ->paginate(10);
  //   return view('theme.invitations', compact('invitations'));
  // }
  public function invitation($slug)
  {
    $invitation = Invitation::where('invitation_url', $slug)->firstOrFail();
    return view('theme.invitation', compact('invitation'));
  }
  public function profile()
  {
    return view('theme.profile');
  }
  public function templates()
  {
    return "templates";
  }
  public function settings()
  {
    return view('theme.settings');
  }
}
